/*
 * Decompiled with CFR 0.152.
 */
package br.com.gertec.tc.server.util.version;

import br.com.gertec.tc.server.Application;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class VersionsWithAudio {
    private static int tc506mVersions;
    private static int tc506Versions;
    private static int tc508Versions;
    private static int tc406Versions;

    public VersionsWithAudio() {
        this.createVersionFile();
        this.updateVersionFile();
        this.fillVersionList();
    }

    private void fillVersionList() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(new File(Application.APP_DIR, "AudioVersions.VERSIONS")));
            while ((line = br.readLine()) != null) {
                String[] aux = line.split(",");
                if (aux[0].equals("TC506M")) {
                    tc506mVersions = Integer.parseInt(aux[1]);
                    continue;
                }
                if (aux[0].equals("TC406")) {
                    tc406Versions = Integer.parseInt(aux[1]);
                    continue;
                }
                if (aux[0].contentEquals("TC506")) {
                    tc506Versions = Integer.parseInt(aux[1]);
                    continue;
                }
                if (!aux[0].equals("TC508")) continue;
                tc508Versions = Integer.parseInt(aux[1]);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createVersionFile() {
        if (!new File(Application.APP_DIR, "AudioVersions.VERSIONS").exists()) {
            try {
                ArrayList<String> hardCodedVersions = new ArrayList<String>();
                hardCodedVersions.add("TC406,200");
                hardCodedVersions.add("TC506M,330");
                BufferedWriter fr = new BufferedWriter(new FileWriter(new File(Application.APP_DIR, "AudioVersions.VERSIONS")));
                for (String s : hardCodedVersions) {
                    fr.write(s + "\n");
                }
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateVersionFile() {
        if (new File(Application.APP_DIR, "AudioVersions.VERSIONS").exists()) {
            try {
                ArrayList<String> hardCodedVersions = new ArrayList<String>();
                hardCodedVersions.add("TC406,200");
                hardCodedVersions.add("TC506M,330");
                BufferedWriter fr = new BufferedWriter(new FileWriter(new File(Application.APP_DIR, "AudioVersions.VERSIONS")));
                for (String s : hardCodedVersions) {
                    fr.write(s + "\n");
                }
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isTC506MAudio(String version) {
        return Integer.parseInt(version) >= tc506mVersions;
    }

    public static boolean isTC406Audio(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        version = version.replaceAll("[^\\d.]", "");
        return Integer.parseInt(version = version.replace(".", "")) >= tc406Versions && !version.equals("4.0");
    }

    public static boolean iTC506Audio(String version) {
        return Integer.parseInt(version) >= tc506Versions;
    }

    public boolean isTC508Audio(String version) {
        return Integer.parseInt(version) >= tc508Versions;
    }
}

