/*
 * Decompiled with CFR 0.152.
 */
package br.com.rybena.tts.api;

import br.com.rybena.tts.api.TTSClient;
import br.com.rybena.tts.api.exception.ErrorType;
import br.com.rybena.tts.api.exception.ExceptionsError;
import br.com.rybena.tts.api.exception.TTSException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Scanner;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class OnlineTTSClient
implements TTSClient {
    protected static final String SERVICE_URL_WAV = "https://tts.rybena.com.br/RybenaServerTTS/GertecApplication/wav/%s";
    protected static final String SERVICE_URL_ALIVE = "https://tts.rybena.com.br/RybenaServerTTS/GertecApplication/status";
    protected static final AudioFormat DEFAULT_AUDIO_FORMAT = new AudioFormat(22050.0f, 16, 1, true, false);
    protected static final int CON_TIME_OUT = 10000;

    @Override
    public TTSClient.TTSType getType() {
        return TTSClient.TTSType.ONLINE;
    }

    private String textCorrectionToCents(String text) {
        String[] valuesToChange;
        String[] stringArray = valuesToChange = new String[]{"R$", "$", "EUR"};
        int n = valuesToChange.length;
        int n2 = 0;
        while (n2 < n) {
            String valueToChange = stringArray[n2];
            valueToChange = String.valueOf(valueToChange) + "0,";
            int offset = valueToChange.length();
            int end = 0;
            String firstPart = "";
            String secondPart = "";
            while (text.indexOf(valueToChange) != -1) {
                int begin = text.indexOf(valueToChange);
                end = text.indexOf(" ", begin + offset);
                if (end == -1) {
                    end = text.length();
                }
                firstPart = text.substring(0, begin);
                secondPart = text.substring(end);
                String value = text.substring(begin + offset, end);
                text = String.valueOf(firstPart) + value + " centavos" + secondPart;
            }
            ++n2;
        }
        return text;
    }

    private String getUUID() {
        try {
            String uuid = OnlineTTSClient.execCmd("findmnt / -o UUID -n").replaceAll("-", "");
            return Base64.getEncoder().encodeToString(uuid.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return "not-found";
        }
    }

    public static String execCmd(String cmd) throws IOException {
        Scanner s = new Scanner(Runtime.getRuntime().exec(cmd).getInputStream()).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    @Override
    public boolean isAlive() {
        try {
            URL url = new URL(SERVICE_URL_ALIVE);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setRequestProperty("User-Agent", "Gertec lib");
            httpConn.setRequestProperty("Referer", this.getUUID());
            httpConn.setConnectTimeout(10000);
            int responseCode = httpConn.getResponseCode();
            System.out.println(responseCode);
            return responseCode == 200;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public AudioInputStream speak(String text) throws Throwable {
        AudioInputStream audioInputStream;
        block16: {
            AudioInputStream ret = null;
            text = this.textCorrectionToCents(text);
            String b64text = Base64.getEncoder().encodeToString(text.getBytes(StandardCharsets.UTF_8));
            String callUrl = String.format(SERVICE_URL_WAV, b64text);
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            File file = new File("log.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter pw = new PrintWriter(bw);
            pw.println("[" + dtf.format(now) + "] Text: " + text + " / B64: " + b64text);
            pw.close();
            Throwable var5 = null;
            Object var6 = null;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int buffer;
                URL url = new URL(callUrl);
                HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
                httpConn.setRequestProperty("User-Agent", "Gertec lib");
                httpConn.setRequestProperty("Referer", this.getUUID());
                httpConn.setConnectTimeout(10000);
                int responseCode = httpConn.getResponseCode();
                if (responseCode != 200) {
                    throw new TTSException(ErrorType.INTEGRATION_ERROR, ExceptionsError.REMOTE_SERVER_ERROR);
                }
                System.out.println(httpConn.getContentLength());
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                String contentType = httpConn.getContentType();
                int contentLength = httpConn.getContentLength();
                InputStream inputStream = httpConn.getInputStream();
                int bytesRead = 0;
                boolean var17 = true;
                while ((buffer = inputStream.read()) != -1) {
                    if (bytesRead > 49) {
                        outputStream.write(buffer);
                    }
                    ++bytesRead;
                }
                byte[] audioRaw = outputStream.toByteArray();
                ret = new AudioInputStream(new ByteArrayInputStream(audioRaw), DEFAULT_AUDIO_FORMAT, audioRaw.length / 2);
                inputStream.close();
                httpConn.disconnect();
                audioInputStream = ret;
                if (outputStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        throw throwable;
                    }
                    catch (Throwable var26) {
                        if (var5 == null) {
                            var5 = var26;
                        } else if (var5 != var26) {
                            var5.addSuppressed(var26);
                        }
                        throw var5;
                    }
                }
                catch (IOException var27) {
                    var27.printStackTrace();
                    throw new TTSException(ErrorType.INTEGRATION_ERROR, (Throwable)var27);
                }
            }
            outputStream.close();
        }
        return audioInputStream;
    }
}

