/*
 * Decompiled with CFR 0.152.
 */
package br.org.reconcavo.event;

import br.org.reconcavo.event.Event;
import br.org.reconcavo.event.EventCaller;
import br.org.reconcavo.event.EventLoopListener;
import br.org.reconcavo.event.Listener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

public class EventLoop
implements Executor {
    public static final Event EVT_START = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((EventLoopListener)listener).onStart((EventLoop)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((EventLoop)args[0]).onStart();
        }
    };
    public static final Event EVT_STOP = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((EventLoopListener)listener).onStop((EventLoop)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((EventLoop)args[0]).onStop();
        }
    };
    private final List<CoreEvent> eventQueue = new LinkedList<CoreEvent>();
    private final EventCaller<EventLoopListener> eventCaller = new EventCaller(this, false);
    private final String name;
    private LoopThread loopThread = null;
    private Throwable uncaughtError = null;
    private CoreEvent currentEvent = null;

    public static StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    public EventLoop() {
        this("event-loop");
    }

    public EventLoop(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/Empty name");
        }
        this.name = name;
    }

    public void addListener(EventLoopListener listener) {
        this.eventCaller.addListener(listener);
    }

    public void addListener(EventLoopListener listener, boolean prepend) {
        this.eventCaller.addListener(listener, prepend);
    }

    public void removeListener(EventLoopListener listener) {
        this.eventCaller.removeListener(listener);
    }

    public void startAndWait() throws Throwable {
        try {
            this.start().join();
            if (this.uncaughtError != null) {
                throw this.uncaughtError;
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Thread start() {
        if (this.loopThread != null && this.loopThread.isAlive()) {
            throw new RuntimeException("Event-loop is already associated with a thread");
        }
        this.uncaughtError = null;
        this.loopThread = new LoopThread();
        String name = this.getName();
        if (name != null && !name.trim().isEmpty()) {
            this.loopThread.setName(name.trim());
        }
        this.loopThread.start();
        return this.loopThread;
    }

    public void stop() {
        if (this.isRunning()) {
            ((LoopThread)this.getThread()).stopThread();
        }
    }

    public boolean isRunning() {
        Thread t = this.getThread();
        return t != null && t.isAlive();
    }

    public Thread getThread() {
        return this.loopThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable cannot be null");
        }
        if (!(runnable instanceof EventRunnable)) {
            runnable = new EventRunnable(runnable);
        }
        if (Thread.currentThread() != this.getThread()) {
            List<CoreEvent> list = this.eventQueue;
            synchronized (list) {
                this.eventQueue.add(new CoreEvent(runnable));
                this.eventQueue.notify();
            }
        } else {
            this.appendRunnableToCurrentEvent(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Null runnable");
        }
        List<CoreEvent> list = this.eventQueue;
        synchronized (list) {
            this.processQueue();
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        if (Thread.currentThread() != this.getThread()) {
            throw new RuntimeException("Cannot process queue outside of event-loop thread");
        }
        List<CoreEvent> list = this.eventQueue;
        synchronized (list) {
            this.processEventQueue(this.currentEvent);
            while (!this.eventQueue.isEmpty()) {
                CoreEvent previousEvent = this.currentEvent;
                this.currentEvent = this.eventQueue.remove(0);
                this.processEvent(this.currentEvent);
                this.currentEvent = previousEvent;
            }
        }
    }

    public void throwError(final Throwable error) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new RuntimeException(error);
            }
        });
    }

    @Override
    public final void execute(Runnable runnable) {
        this.invokeLater(runnable);
    }

    protected String getName() {
        return this.name;
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    protected void processRunnable(Runnable runnable) {
        runnable.run();
    }

    protected boolean onUncaughtError(Throwable ex) {
        return false;
    }

    private void processEvent(CoreEvent event) {
        this.processRunnable(event.runnable);
        this.processEventQueue(event);
    }

    private void processEventQueue(CoreEvent event) {
        while (!event.queue.isEmpty()) {
            Runnable runnable = event.queue.remove(0);
            this.processRunnable(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunnableToCurrentEvent(int index, Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable cannot be null");
        }
        if (Thread.currentThread() != this.getThread()) {
            throw new RuntimeException("Cannot append runnable outside of event-loop thread");
        }
        if (this.currentEvent == null) {
            this.currentEvent = new CoreEvent(runnable);
            List<CoreEvent> list = this.eventQueue;
            synchronized (list) {
                this.eventQueue.add(index == -1 ? this.eventQueue.size() : index, this.currentEvent);
            }
        } else {
            this.currentEvent.appendRunnable(runnable);
        }
    }

    private final void appendRunnableToCurrentEvent(Runnable runnable) {
        this.addRunnableToCurrentEvent(-1, runnable);
    }

    private class LoopThread
    extends Thread {
        private volatile boolean stop = false;
        private volatile boolean notifyUnexpectedStop = true;

        private LoopThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopThread() {
            boolean wasAlive = this.notifyUnexpectedStop;
            if (Thread.currentThread() == this) {
                this.notifyUnexpectedStop = false;
            }
            this.stop = true;
            List list = EventLoop.this.eventQueue;
            synchronized (list) {
                EventLoop.this.eventQueue.notify();
            }
            try {
                if (this.isAlive() && Thread.currentThread() != this) {
                    this.join();
                }
                if (wasAlive && Thread.currentThread() == this) {
                    EventLoop.this.eventCaller.notifyEvent(EVT_STOP, EventLoop.this);
                    EventLoop.this.processQueue();
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventLoop.this.addRunnableToCurrentEvent(0, new Runnable(){

                @Override
                public void run() {
                    EventLoop.this.eventCaller.notifyEvent(EVT_START, EventLoop.this);
                }
            });
            while (!this.stop) {
                List list = EventLoop.this.eventQueue;
                synchronized (list) {
                    try {
                        if (EventLoop.this.eventQueue.isEmpty()) {
                            EventLoop.this.currentEvent = null;
                            EventLoop.this.eventQueue.wait();
                        }
                        if (this.stop) {
                            break;
                        }
                        if (!EventLoop.this.eventQueue.isEmpty()) {
                            EventLoop.this.currentEvent = (CoreEvent)EventLoop.this.eventQueue.remove(0);
                        }
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (EventLoop.this.currentEvent == null) continue;
                try {
                    EventLoop.this.processEvent(EventLoop.this.currentEvent);
                }
                catch (Throwable t) {
                    if (EventLoop.this.onUncaughtError(t)) continue;
                    EventLoop.this.uncaughtError = t;
                    break;
                }
            }
            if (this.notifyUnexpectedStop) {
                EventLoop.this.eventCaller.notifyEvent(EVT_STOP, EventLoop.this);
                EventLoop.this.processQueue();
                this.notifyUnexpectedStop = false;
            }
        }
    }

    public static class EventError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final StackTraceElement[] callerStackTrace;

        public EventError(Throwable cause) {
            super(cause);
            this.callerStackTrace = this.getStackTrace();
        }

        public EventError(Throwable cause, StackTraceElement[] callerStackTrace) {
            super(cause);
            this.callerStackTrace = callerStackTrace;
        }

        public StackTraceElement[] getCallerStackTrace() {
            return this.callerStackTrace;
        }
    }

    private static class EventRunnable
    implements Runnable {
        private final Runnable wrappedRunnable;

        public EventRunnable(Runnable wrappedRunnable) {
            this.wrappedRunnable = wrappedRunnable;
        }

        public Runnable getWrappedRunnable() {
            return this.wrappedRunnable;
        }

        @Override
        public void run() {
            this.getWrappedRunnable().run();
        }
    }

    private static class CoreEvent {
        public final Runnable runnable;
        public final List<Runnable> queue = new LinkedList<Runnable>();
        private final String name;

        CoreEvent(Runnable runnable, String name) {
            this.runnable = runnable;
            this.name = name;
        }

        public CoreEvent(Runnable runnable) {
            this(runnable, null);
        }

        public void appendRunnable(Runnable runnable) {
            this.queue.add(runnable);
        }

        public String toString() {
            if (this.name == null || this.name.trim().isEmpty()) {
                return super.toString();
            }
            return this.name;
        }
    }
}

