/*
 * Decompiled with CFR 0.152.
 */
package br.org.reconcavo.event;

import br.org.reconcavo.event.Event;
import br.org.reconcavo.event.EventCaller;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Listener;
import br.org.reconcavo.event.ProcessListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Process
extends EventCaller<ProcessListener> {
    public static final Event EVT_START = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ProcessListener)listener).onStart((Process)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((Process)args[0]).onStart();
        }
    };
    public static final Event EVT_OUTPUT = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ProcessListener)listener).onOutput((Process)args[0], (String)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((Process)args[0]).onOutput((String)args[1]);
        }
    };
    public static final Event EVT_STOP = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ProcessListener)listener).onStop((Process)args[0], (Integer)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((Process)args[0]).onStop((Integer)args[1]);
        }
    };
    private final String[] cmdArray;
    private java.lang.Process coreProcess;

    private static String[] getCommandArray(String singleElement) {
        LinkedList<String> matchList = new LinkedList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(singleElement);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public Process(EventLoop eventLoop, String command) {
        super(eventLoop);
        if (command == null || command.trim().isEmpty()) {
            throw new IllegalArgumentException("Null/Empty command");
        }
        this.cmdArray = Process.getCommandArray(command);
    }

    public Process(EventLoop eventLoop, String[] cmdArray) {
        super(eventLoop);
        if (cmdArray == null) {
            throw new IllegalArgumentException("Null cmd array");
        }
        for (int i = 0; i < cmdArray.length; ++i) {
            if (cmdArray[i] != null && !cmdArray[i].trim().isEmpty()) continue;
            throw new IllegalArgumentException("Null/Empty element at index " + i);
        }
        this.cmdArray = Arrays.copyOf(cmdArray, cmdArray.length);
    }

    public boolean isRunning() {
        return this.coreProcess != null && this.coreProcess.isAlive();
    }

    @Deprecated
    public String getCommand() {
        return this.getLaunchCommand();
    }

    public String getLaunchCommand() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.cmdArray.length; ++i) {
            String arg;
            if (i > 0) {
                sb.append(" ");
            }
            if ((arg = this.cmdArray[i]).contains(" ") && !arg.startsWith("\"") && !arg.endsWith("\"")) {
                arg = String.format("\"%s\"", arg);
            }
            sb.append(arg);
        }
        return sb.toString();
    }

    public final String[] getCommandArray() {
        return Arrays.copyOf(this.cmdArray, this.cmdArray.length);
    }

    public void start(File cwd, boolean wait) {
        final File mCwd = cwd;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String[] stringArray = Process.this.cmdArray;
                    synchronized (stringArray) {
                        Process.this.coreProcess = Runtime.getRuntime().exec(Process.this.cmdArray, null, mCwd);
                    }
                    Process.this.notifyEvent(EVT_START, Process.this);
                    String[] is = Process.this.coreProcess.getInputStream();
                    InputStream es = Process.this.coreProcess.getErrorStream();
                    try (BufferedReader ibr = new BufferedReader(new InputStreamReader((InputStream)is));
                         BufferedReader ebr = new BufferedReader(new InputStreamReader(es));){
                        String line = null;
                        while ((line = ibr.readLine()) != null) {
                            Process.this.notifyEvent(EVT_OUTPUT, Process.this, line);
                        }
                        while ((line = ebr.readLine()) != null) {
                            Process.this.notifyEvent(EVT_OUTPUT, Process.this, line);
                        }
                        Process.this.coreProcess.waitFor();
                        Process.this.notifyEvent(EVT_STOP, Process.this, Process.this.coreProcess.exitValue());
                        String[] stringArray2 = Process.this.cmdArray;
                        synchronized (stringArray2) {
                            Process.this.coreProcess = null;
                        }
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    String[] stringArray = Process.this.cmdArray;
                    synchronized (stringArray) {
                        if (Process.this.coreProcess != null) {
                            Process.this.coreProcess.destroy();
                            Process.this.coreProcess = null;
                        }
                    }
                }
            }
        };
        if (wait) {
            runnable.run();
        } else {
            Thread t = new Thread(runnable);
            t.setName("process-monitor");
            t.start();
        }
    }

    public void start() {
        this.start(null, false);
    }

    public void start(File cwd) {
        this.start(cwd, false);
    }

    public void startAndWait() {
        this.start(null, true);
    }

    public void startAndWait(File cwd) {
        this.start(cwd, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String[] stringArray = this.cmdArray;
        synchronized (this.cmdArray) {
            if (this.coreProcess == null) {
                throw new IllegalStateException("Process is not running");
            }
            this.coreProcess.destroy();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void onOutput(String read) {
    }

    protected void onStart() {
    }

    protected void onStop(int exitCode) {
    }

    public String toString() {
        return this.getLaunchCommand();
    }

    public static class CommandArgBuilder {
        public final List<String> cmdArgList = new LinkedList<String>();

        public CommandArgBuilder(String baseCommand) {
            if (baseCommand == null || baseCommand.trim().isEmpty()) {
                throw new IllegalArgumentException("Null/Empty base command");
            }
            this.cmdArgList.add(baseCommand);
        }

        public String getBaseCommand() {
            return this.cmdArgList.get(0);
        }

        public CommandArgBuilder addArg(String arg) {
            if (arg == null || arg.isEmpty()) {
                throw new IllegalArgumentException("Null/Empty arg");
            }
            this.cmdArgList.add(arg);
            return this;
        }

        public Process build(EventLoop eventLoop) {
            return new Process(eventLoop, this.cmdArgList.toArray(new String[this.cmdArgList.size()]));
        }
    }

    @Deprecated
    public static class ProcessBuilder {
        private final StringBuilder cmdBuilder;
        private final String baseCommand;

        public ProcessBuilder(String baseCommand) {
            if (baseCommand == null || baseCommand.trim().isEmpty()) {
                throw new IllegalArgumentException("Null/Empty base command");
            }
            this.baseCommand = baseCommand;
            this.cmdBuilder = new StringBuilder(baseCommand);
        }

        public String getBaseCommand() {
            return this.baseCommand;
        }

        public ProcessBuilder addArg(String arg) {
            if (arg == null || arg.isEmpty()) {
                throw new IllegalArgumentException("Null/Empty arg");
            }
            this.cmdBuilder.append(" ").append(arg);
            return this;
        }

        public Process build(EventLoop eventLoop) {
            return new Process(eventLoop, this.cmdBuilder.toString());
        }
    }
}

