/*
 * Decompiled with CFR 0.152.
 */
package br.org.reconcavo.event.comm;

import br.org.reconcavo.event.Event;
import br.org.reconcavo.event.EventCaller;
import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.Listener;
import br.org.reconcavo.event.comm.ConnectionListener;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.IOException;

public abstract class AbstractConnection
extends EventCaller<ConnectionListener> {
    public static final Event EVT_OPEN = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ConnectionListener)listener).onOpen((AbstractConnection)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((AbstractConnection)args[0]).onOpen();
        }
    };
    public static final Event EVT_CLOSE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ConnectionListener)listener).onClose((AbstractConnection)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((AbstractConnection)args[0]).onClose();
        }
    };
    public static final Event EVT_DATA_READ = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ConnectionListener)listener).onDataRead((AbstractConnection)args[0], (DataBuffer)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((AbstractConnection)args[0]).onDataRead((DataBuffer)args[1]);
        }
    };
    public static final Event EVT_DATA_WRITE = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ConnectionListener)listener).onDataWrite((AbstractConnection)args[0], (byte[])args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((AbstractConnection)args[0]).onDataWrite((byte[])args[1]);
        }
    };
    public static final Event EVT_ERROR = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((ConnectionListener)listener).onError((AbstractConnection)args[0], (Throwable)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((AbstractConnection)args[0]).onError((Throwable)args[1]);
        }
    };

    public AbstractConnection(EventLoop eventLoop) {
        super(eventLoop);
    }

    @Override
    protected void onEventLoopStop() {
        if (this.isOpen()) {
            this.close();
        }
    }

    protected void onOpen() {
    }

    protected void onClose() {
    }

    protected void onDataRead(DataBuffer dataBuffer) {
    }

    protected void onDataWrite(byte[] data) {
    }

    protected void onError(Throwable error) {
    }

    abstract void doWrite(byte[] var1) throws IOException;

    public final boolean write(byte[] data) {
        try {
            this.doWrite(data);
            return true;
        }
        catch (Throwable ex) {
            this.notifyEvent(EVT_ERROR, this, ex);
            return false;
        }
    }

    public abstract boolean isOpen();

    public abstract void close();
}

