/*
 * Decompiled with CFR 0.152.
 */
package br.org.reconcavo.event.comm;

import br.org.reconcavo.event.EventLoop;
import br.org.reconcavo.event.comm.AbstractConnection;
import br.org.reconcavo.event.comm.ConnectionChannel;
import br.org.reconcavo.event.comm.DataBuffer;
import java.io.IOException;

public abstract class AbstractRawConnection
extends AbstractConnection {
    private static final long DEFAULT_READ_INTERVAL = 1L;
    private final DataBuffer dataBuffer = new DataBuffer();
    private ReaderThread readerThread;
    private ConnectionChannel connectionChannel;

    public AbstractRawConnection(EventLoop eventLoop) {
        super(eventLoop);
    }

    @Override
    final void doWrite(byte[] data) throws IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Connection is not open");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Null/Empty data");
        }
        this.connectionChannel.write(data);
        this.notifyEvent(EVT_DATA_WRITE, this, data);
    }

    protected String getReaderThreadName(Object ... args) {
        return "connection-reader";
    }

    protected long getReadInterval() {
        return 1L;
    }

    ConnectionChannel getEffectiveChannel() {
        return this.connectionChannel;
    }

    protected abstract ConnectionChannel getChannel(Object ... var1) throws Throwable;

    protected void open(Object ... args) {
        try {
            if (this.isOpen()) {
                throw new IllegalStateException("Connection is already open");
            }
            this.dataBuffer.clear();
            this.connectionChannel = this.getChannel(args);
            this.readerThread = new ReaderThread();
            String readerThreadName = this.getReaderThreadName(args);
            if (readerThreadName != null && !readerThreadName.trim().isEmpty()) {
                this.readerThread.setName(readerThreadName.trim());
            }
            this.readerThread.start();
            this.notifyEvent(EVT_OPEN, this);
        }
        catch (Throwable ex) {
            this.notifyEvent(EVT_ERROR, this, ex);
        }
    }

    @Override
    public boolean isOpen() {
        return this.readerThread != null && this.readerThread.isAlive();
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.readerThread.stopThread();
        }
    }

    private class ReaderThread
    extends Thread {
        private volatile boolean notifyUnexpectedClose = true;

        private ReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            try {
                boolean wasAlive = this.notifyUnexpectedClose;
                this.notifyUnexpectedClose = false;
                ConnectionChannel connectionChannel = AbstractRawConnection.this.connectionChannel;
                synchronized (connectionChannel) {
                    AbstractRawConnection.this.connectionChannel.close();
                    AbstractRawConnection.this.connectionChannel.notify();
                }
                if (this.isAlive()) {
                    this.join();
                }
                if (wasAlive) {
                    AbstractRawConnection.this.notifyEvent(AbstractConnection.EVT_CLOSE, AbstractRawConnection.this);
                }
            }
            catch (IOException ex) {
                AbstractRawConnection.this.notifyEvent(AbstractConnection.EVT_ERROR, AbstractRawConnection.this, ex);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long readInterval = AbstractRawConnection.this.getReadInterval();
            while (true) {
                byte[] data = null;
                try {
                    ConnectionChannel connectionChannel = AbstractRawConnection.this.connectionChannel;
                    synchronized (connectionChannel) {
                        if (!AbstractRawConnection.this.connectionChannel.isOpen()) {
                            break;
                        }
                        int available = AbstractRawConnection.this.connectionChannel.getAvailableRead();
                        if (available == 0) {
                            if (readInterval < 1L) {
                                continue;
                            }
                            AbstractRawConnection.this.connectionChannel.wait(readInterval);
                        } else {
                            data = available > 0 ? AbstractRawConnection.this.connectionChannel.read() : null;
                        }
                        if (available == 0) {
                            if (!AbstractRawConnection.this.connectionChannel.isOpen()) {
                                break;
                            }
                            continue;
                        }
                    }
                    if (data == null) break;
                    if (data.length <= 0) continue;
                    AbstractRawConnection.this.dataBuffer.put(data);
                    AbstractRawConnection.this.notifyEvent(AbstractConnection.EVT_DATA_READ, AbstractRawConnection.this, AbstractRawConnection.this.dataBuffer);
                }
                catch (IOException ex) {
                    AbstractRawConnection.this.notifyEvent(AbstractConnection.EVT_ERROR, AbstractRawConnection.this, ex);
                    break;
                }
                catch (InterruptedException ex) {
                    AbstractRawConnection.this.getEventLoop().throwError(ex);
                    break;
                }
            }
            if (this.notifyUnexpectedClose) {
                AbstractRawConnection.this.notifyEvent(AbstractConnection.EVT_CLOSE, AbstractRawConnection.this);
                this.notifyUnexpectedClose = false;
                try {
                    AbstractRawConnection.this.connectionChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

