/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.synthesiser;

import com.darkprograms.speech.translator.GoogleTranslate;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSynthsiser {
    public abstract InputStream getMP3Data(String var1) throws IOException;

    public InputStream getMP3Data(List<String> synthText) throws IOException {
        ExecutorService pool = Executors.newFixedThreadPool(1000);
        LinkedHashSet<Future<InputStream>> set = new LinkedHashSet<Future<InputStream>>(synthText.size());
        for (String part : synthText) {
            MP3DataFetcher mP3DataFetcher = new MP3DataFetcher(part);
            Future<InputStream> future = pool.submit(mP3DataFetcher);
            set.add(future);
        }
        ArrayList inputStreams = new ArrayList(set.size());
        for (Future future : set) {
            try {
                inputStreams.add(future.get());
            }
            catch (ExecutionException e) {
                Throwable ex = e.getCause();
                if (!(ex instanceof IOException)) continue;
                throw (IOException)ex;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return new SequenceInputStream(Collections.enumeration(inputStreams));
    }

    protected List<String> parseString(String input) {
        return this.parseString(input, new ArrayList<String>());
    }

    private List<String> parseString(String input, List<String> fragments) {
        if (input.length() <= 100) {
            fragments.add(input);
            return fragments;
        }
        int lastWord = this.findLastWord(input);
        if (lastWord <= 0) {
            fragments.add(input.substring(0, 100));
            return this.parseString(input.substring(100), fragments);
        }
        fragments.add(input.substring(0, lastWord));
        return this.parseString(input.substring(lastWord), fragments);
    }

    private int findLastWord(String input) {
        if (input.length() < 100) {
            return input.length();
        }
        int space = -1;
        for (int i = 99; i > 0; --i) {
            char tmp = input.charAt(i);
            if (this.isEndingPunctuation(tmp)) {
                return i + 1;
            }
            if (space != -1 || tmp != ' ') continue;
            space = i;
        }
        if (space > 0) {
            return space;
        }
        return -1;
    }

    private boolean isEndingPunctuation(char input) {
        return input == '.' || input == '!' || input == '?' || input == ';' || input == ':' || input == '|';
    }

    public String detectLanguage(String text) throws IOException {
        return GoogleTranslate.detectLanguage(text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MP3DataFetcher
    implements Callable<InputStream> {
        private String synthText;

        public MP3DataFetcher(String synthText) {
            this.synthText = synthText;
        }

        @Override
        public InputStream call() throws IOException {
            return BaseSynthsiser.this.getMP3Data(this.synthText);
        }
    }
}

