/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ChunkedOutputStream
extends BufferedOutputStream {
    private static final byte[] crlf = new byte[]{13, 10};
    private byte[] lenBytes = new byte[20];
    private List<String> footerNames = new ArrayList<String>();
    private List<String> footerValues = new ArrayList<String>();

    public ChunkedOutputStream(OutputStream out) {
        super(out);
    }

    public ChunkedOutputStream(OutputStream out, int size) {
        super(out, size);
    }

    public synchronized void flush() throws IOException {
        if (this.count != 0) {
            this.writeBuf(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void setFooter(String name, String value) {
        this.footerNames.add(name);
        this.footerValues.add(value);
    }

    public void done() throws IOException {
        this.flush();
        PrintStream pout = new PrintStream(this.out);
        pout.println("0");
        if (this.footerNames.size() > 0) {
            for (int i = 0; i < this.footerNames.size(); ++i) {
                String name = this.footerNames.get(i);
                String value = this.footerValues.get(i);
                pout.println(name + ": " + value);
            }
        }
        this.footerNames = null;
        this.footerValues = null;
        pout.println("");
        pout.flush();
    }

    public void close() throws IOException {
        if (this.footerNames != null) {
            this.done();
        }
        super.close();
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int avail = this.buf.length - this.count;
        if (len <= avail) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
            return;
        }
        this.flush();
        this.writeBuf(b, off, len);
    }

    private void writeBuf(byte[] b, int off, int len) throws IOException {
        String lenStr = Integer.toString(len, 16);
        lenStr.getBytes(0, lenStr.length(), this.lenBytes, 0);
        this.out.write(this.lenBytes);
        this.out.write(crlf);
        if (len != 0) {
            this.out.write(b, off, len);
        }
        this.out.write(crlf);
        this.out.flush();
    }
}

