/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import net.sourceforge.javaflacencoder.FLACEncoder;

public class AudioStreamEncoder {
    public static final int SUPPORTED = 0;
    public static final int UNSUPPORTED_CHANNELCOUNT = 1;
    public static final int UNSUPPORTED_SAMPLESIZE = 2;
    public static final int UNSUPPORTED_SAMPLERATE = 4;
    public static final int UNSUPPORTED_ENCODINGTYPE = 8;

    public static int encodeAudioInputStream(AudioInputStream sin, int maxRead, FLACEncoder flac, boolean useThreads) throws IOException, IllegalArgumentException {
        int samplesRead;
        AudioFormat format = sin.getFormat();
        int frameSize = format.getFrameSize();
        int sampleSize = format.getSampleSizeInBits();
        int bytesPerSample = sampleSize / 8;
        if (sampleSize % 8 != 0) {
            throw new IllegalArgumentException("Unsupported Sample Size: size = " + sampleSize);
        }
        int channels = format.getChannels();
        boolean bigEndian = format.isBigEndian();
        boolean isSigned = format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        byte[] samplesIn = new byte[maxRead];
        int[] sampleData = new int[maxRead * channels / frameSize];
        int unencodedSamples = 0;
        int totalSamples = 0;
        while ((samplesRead = sin.read(samplesIn, 0, maxRead)) > 0) {
            int reducer;
            int upShift;
            int x;
            int totalTemp;
            int temp;
            int lower8Mask;
            int i;
            int framesRead = samplesRead / frameSize;
            if (bigEndian) {
                for (i = 0; i < framesRead * channels; ++i) {
                    lower8Mask = 255;
                    temp = 0;
                    totalTemp = 0;
                    for (x = bytesPerSample - 1; x >= 0; ++x) {
                        upShift = 8 * x;
                        temp = x == 0 ? samplesIn[bytesPerSample * i + x] << upShift : (samplesIn[bytesPerSample * i + x] & lower8Mask) << upShift;
                        totalTemp |= temp;
                    }
                    if (!isSigned) {
                        reducer = 1 << bytesPerSample * 8 - 1;
                        totalTemp -= reducer;
                    }
                    sampleData[i] = totalTemp;
                }
            } else {
                for (i = 0; i < framesRead * channels; ++i) {
                    lower8Mask = 255;
                    temp = 0;
                    totalTemp = 0;
                    for (x = 0; x < bytesPerSample; ++x) {
                        upShift = 8 * x;
                        temp = x == bytesPerSample - 1 && isSigned ? samplesIn[bytesPerSample * i + x] << upShift : (samplesIn[bytesPerSample * i + x] & lower8Mask) << upShift;
                        totalTemp |= temp;
                    }
                    if (!isSigned) {
                        reducer = 1 << bytesPerSample * 8 - 1;
                        totalTemp -= reducer;
                    }
                    sampleData[i] = totalTemp;
                }
            }
            if (framesRead > 0) {
                flac.addSamples(sampleData, framesRead);
                unencodedSamples += framesRead;
            }
            unencodedSamples = useThreads ? (unencodedSamples -= flac.t_encodeSamples(unencodedSamples, false, 5)) : (unencodedSamples -= flac.encodeSamples(unencodedSamples, false));
            totalSamples += unencodedSamples;
        }
        totalSamples += unencodedSamples;
        unencodedSamples = useThreads ? (unencodedSamples -= flac.t_encodeSamples(unencodedSamples, true, 5)) : (unencodedSamples -= flac.encodeSamples(unencodedSamples, true));
        return totalSamples;
    }

    public static int getDataFormatSupport(AudioFormat format) {
        int result = 0;
        float sampleRate = format.getSampleRate();
        AudioFormat.Encoding encoding = format.getEncoding();
        if (format.getChannels() > 8 || format.getChannels() < 1) {
            result |= 1;
        }
        if (format.getSampleSizeInBits() > 24 || format.getSampleSizeInBits() % 8 != 0) {
            result |= 2;
        }
        if (sampleRate <= 0.0f || sampleRate > 655350.0f || sampleRate == -1.0f) {
            result |= 4;
        }
        if (!(AudioFormat.Encoding.ALAW.equals(encoding) || AudioFormat.Encoding.ULAW.equals(encoding) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding))) {
            result |= 8;
        }
        return result;
    }
}

