/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.AudioFileWriter;
import net.sourceforge.javaflacencoder.AudioStreamEncoder;
import net.sourceforge.javaflacencoder.EncodingConfiguration;
import net.sourceforge.javaflacencoder.FLACEncoder;
import net.sourceforge.javaflacencoder.FLACFileOutputStream;
import net.sourceforge.javaflacencoder.FLACStreamOutputStream;
import net.sourceforge.javaflacencoder.StreamConfiguration;

public class FLACFileWriter
extends AudioFileWriter {
    public static final AudioFileFormat.Type FLAC = new AudioFileFormat.Type("FLAC", "flac");
    private static final AudioFileFormat.Type[] flacTypes = new AudioFileFormat.Type[]{FLAC};
    private static final int MAX_READ = 16384;

    public AudioFileFormat.Type[] getAudioFileTypes() {
        AudioFileFormat.Type[] localArray = new AudioFileFormat.Type[flacTypes.length];
        System.arraycopy(flacTypes, 0, localArray, 0, flacTypes.length);
        return localArray;
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFileFormat.Type[] filetypes = this.getAudioFileTypes();
        AudioFormat format = stream.getFormat();
        if (AudioStreamEncoder.getDataFormatSupport(format) == 0) {
            return filetypes;
        }
        return new AudioFileFormat.Type[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        if (!flacTypes[0].equals(fileType)) {
            throw new IllegalArgumentException("File type " + fileType + " not supported.");
        }
        if (AudioStreamEncoder.getDataFormatSupport(stream.getFormat()) != 0) {
            throw new IllegalArgumentException("Data Format not supported");
        }
        FLACFileOutputStream flacFileOutputStream = null;
        int bytesWritten = 0;
        try {
            flacFileOutputStream = new FLACFileOutputStream(out);
            AudioFormat format = stream.getFormat();
            StreamConfiguration streamConfiguration = this.adjustConfigurations(format);
            EncodingConfiguration encodingConfiguration = new EncodingConfiguration();
            FLACEncoder flac = new FLACEncoder();
            if (!flac.setStreamConfiguration(streamConfiguration) || !flac.setEncodingConfiguration(encodingConfiguration)) {
                throw new IOException("FLAC encoder initialization failed.");
            }
            flac.setOutputStream(flacFileOutputStream);
            flac.openFLACStream();
            AudioStreamEncoder.encodeAudioInputStream(stream, 16384, flac, false);
        }
        finally {
            if (flacFileOutputStream != null) {
                bytesWritten = Long.valueOf(flacFileOutputStream.size()).intValue();
                flacFileOutputStream.close();
            }
        }
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        if (!flacTypes[0].equals(fileType)) {
            throw new IllegalArgumentException("File type " + fileType + " not supported.");
        }
        if (AudioStreamEncoder.getDataFormatSupport(stream.getFormat()) != 0) {
            throw new IllegalArgumentException("Data Format not supported");
        }
        FLACStreamOutputStream flacStreamOutputStream = null;
        int bytesWritten = 0;
        try {
            flacStreamOutputStream = new FLACStreamOutputStream(out);
            AudioFormat format = stream.getFormat();
            StreamConfiguration streamConfiguration = this.adjustConfigurations(format);
            EncodingConfiguration encodingConfiguration = new EncodingConfiguration();
            FLACEncoder flac = new FLACEncoder();
            if (!flac.setStreamConfiguration(streamConfiguration) || !flac.setEncodingConfiguration(encodingConfiguration)) {
                throw new IOException("FLAC encoder initialization failed.");
            }
            flac.setOutputStream(flacStreamOutputStream);
            flac.openFLACStream();
            AudioStreamEncoder.encodeAudioInputStream(stream, 16384, flac, false);
        }
        finally {
            if (flacStreamOutputStream != null) {
                bytesWritten = Long.valueOf(flacStreamOutputStream.size()).intValue();
                flacStreamOutputStream.close();
            }
        }
        return bytesWritten;
    }

    private StreamConfiguration adjustConfigurations(AudioFormat format) {
        int sampleRate = (int)format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int channels = format.getChannels();
        StreamConfiguration streamConfiguration = new StreamConfiguration();
        streamConfiguration.setSampleRate(sampleRate);
        streamConfiguration.setBitsPerSample(sampleSize);
        streamConfiguration.setChannelCount(channels);
        return streamConfiguration;
    }
}

