/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import net.sourceforge.javaflacencoder.EncodedElement;
import net.sourceforge.javaflacencoder.StreamConfiguration;

public class MetadataBlockStreamInfo {
    static int DEBUG_LEV = 0;

    public static EncodedElement getStreamInfo(StreamConfiguration sc, int minFrameSize, int maxFrameSize, long samplesInStream, byte[] md5Hash) {
        int bytes = MetadataBlockStreamInfo.getByteSize();
        EncodedElement ele = new EncodedElement(bytes, 0);
        int encodedBitsPerSample = sc.getBitsPerSample() - 1;
        ele.addInt(sc.getMinBlockSize(), 16);
        ele.addInt(sc.getMaxBlockSize(), 16);
        ele.addInt(minFrameSize, 24);
        ele.addInt(maxFrameSize, 24);
        ele.addInt(sc.getSampleRate(), 20);
        ele.addInt(sc.getChannelCount() - 1, 3);
        ele.addInt(encodedBitsPerSample, 5);
        ele.addLong(samplesInStream, 36);
        for (int i = 0; i < 16; ++i) {
            ele.addInt(md5Hash[i], 8);
        }
        return ele;
    }

    public static int getByteSize() {
        int size = 0;
        size += 16;
        size += 16;
        size += 24;
        size += 24;
        size += 20;
        size += 3;
        size += 5;
        size += 36;
        size += 64;
        size += 64;
        return size /= 8;
    }
}

