/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import net.sourceforge.javaflacencoder.EncodedElement;

public class RiceEncoder {
    public static int DEBUG_LEV = 0;
    private static final int POSITIVE = 0;
    private static final int NEGATIVE = 1;
    private static final int STOP_BIT = -1;
    private static final int UNARY_BIT = 0;
    private int[] _dataToEncode = null;
    private int[] _bitsToEncode = null;

    public static int beginResidual(boolean useFiveBitParam, byte order, EncodedElement ele) {
        ele = ele.getEnd();
        int paramSize = useFiveBitParam ? 1 : 0;
        ele.addInt(paramSize, 2);
        ele.addInt(order, 4);
        return 6;
    }

    public static int encodeRicePartitionEscaped(int[] values, int inputOffset, int inputStep, int inputCount, EncodedElement destEle, int bitParam, boolean fiveBitParam) {
        if (DEBUG_LEV > 0) {
            System.err.println("RiceEncoder::encode : Begin");
        }
        int bitsWritten = 0;
        if (fiveBitParam) {
            destEle.addInt(255, 5);
            destEle.addInt(16, 5);
            bitsWritten += 10;
        } else {
            destEle.addInt(255, 4);
            destEle.addInt(16, 5);
            bitsWritten += 9;
        }
        for (int i = 0; i < inputCount; ++i) {
            destEle.addInt(values[i * inputStep + inputOffset], 16);
            bitsWritten += 16;
        }
        if (DEBUG_LEV > 0) {
            System.err.println("RiceEncoder::encode : End");
        }
        return bitsWritten;
    }

    public int encodeRicePartition(int[] values, int inputOffset, int inputStep, int inputCount, EncodedElement destEle, int bitParam, boolean fiveBitParam) {
        if (DEBUG_LEV > 0) {
            System.err.println("RiceEncoder::encode : Begin");
            System.err.println("-- bitParam: " + bitParam);
        }
        int startBits = destEle.getTotalBits();
        if (fiveBitParam) {
            destEle.addInt(bitParam, 5);
        } else {
            destEle.addInt(bitParam, 4);
        }
        if (this._dataToEncode == null || this._bitsToEncode == null) {
            this._dataToEncode = new int[values.length * 4];
            this._bitsToEncode = new int[values.length * 4];
        }
        int[] dataToEncode = this._dataToEncode;
        int[] bitsToEncode = this._bitsToEncode;
        int nextToEncode = 0;
        int maxToEncode = dataToEncode.length;
        int inputIndex = inputOffset - inputStep;
        int stopbit = bitParam > 0 ? -1 << bitParam : -1;
        int maskParam = bitParam == 0 ? 0 : -1 >>> 32 - bitParam;
        for (int i = 0; i < inputCount; ++i) {
            int value = values[inputIndex += inputStep];
            value = value < 0 ? -2 * value - 1 : 2 * value;
            int upperBits = value >> bitParam;
            int dataToEncodeSpaceNeeded = 2 + upperBits / 32;
            if (upperBits % 32 != 0) {
                ++dataToEncodeSpaceNeeded;
            }
            if (dataToEncodeSpaceNeeded + nextToEncode >= maxToEncode) {
                destEle.packIntByBits(dataToEncode, bitsToEncode, 0, nextToEncode);
                nextToEncode = 0;
            }
            int count = 0;
            while (upperBits > 0) {
                int tempVal = upperBits > 32 ? 32 : upperBits;
                dataToEncode[nextToEncode] = 0;
                bitsToEncode[nextToEncode++] = tempVal;
                upperBits -= tempVal;
                ++count;
            }
            dataToEncode[nextToEncode] = value & maskParam | stopbit;
            bitsToEncode[nextToEncode++] = bitParam + 1;
        }
        if (nextToEncode > 0) {
            destEle.packIntByBits(dataToEncode, bitsToEncode, 0, nextToEncode);
            nextToEncode = 0;
        }
        int bitsWritten = destEle.getTotalBits() - startBits;
        return bitsWritten;
    }

    public static int calculateEncodeSize(int[] values, int inputOffset, int inputStep, int inputCount, int bitParam) {
        if (DEBUG_LEV > 0) {
            System.err.println("RiceEncoder::calculateEncodeSize : Begin");
            System.err.println("-- bitParam: " + bitParam);
        }
        int totalEncodeLength = inputCount * (bitParam + 1);
        int index = inputOffset - inputStep;
        for (int i = 0; i < inputCount; ++i) {
            int value = values[index += inputStep];
            value = value < 0 ? -2 * value - 1 : 2 * value;
            int upperBits = value >> bitParam;
            totalEncodeLength += upperBits;
        }
        totalEncodeLength = bitParam > 14 ? (totalEncodeLength += 11) : (totalEncodeLength += 10);
        return totalEncodeLength;
    }
}

