/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import net.sourceforge.javaflacencoder.EncodedElement;
import net.sourceforge.javaflacencoder.EncodingConfiguration;
import net.sourceforge.javaflacencoder.StreamConfiguration;
import net.sourceforge.javaflacencoder.Subframe;

public class Subframe_Constant
extends Subframe {
    public static int DEBUG_LEV = 0;
    public static final EncodingConfiguration.SubframeType type = EncodingConfiguration.SubframeType.VERBATIM;
    int sampleSize = 0;

    public Subframe_Constant(StreamConfiguration sc) {
        super(sc);
        this.sampleSize = sc.getBitsPerSample();
    }

    public boolean registerConfiguration(EncodingConfiguration ec) {
        super.registerConfiguration(ec);
        return true;
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, EncodedElement data, int offset, int bitsPerSample) {
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Verbatim::encodeSamples(...)");
        }
        int encodedSamples = count;
        int bits = bitsPerSample + offset + 8;
        int bytesNeeded = bits / 8;
        if (bits % 8 != 0) {
            ++bytesNeeded;
        }
        data.clear(bytesNeeded, offset);
        data.addInt(0, 1);
        data.addInt(0, 6);
        data.addInt(0, 1);
        int value = samples[start];
        int increment = skip + 1;
        int end = start + increment * count;
        int lastValid = end - increment;
        for (int i = start; i < end; i += increment) {
            if (samples[i] == value) continue;
            lastValid = i - increment;
            break;
        }
        encodedSamples = (lastValid - start) / increment + 1;
        data.addInt(value, bitsPerSample);
        this.lastEncodedSize = bits - offset;
        System.out.flush();
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Verbatim::encodeSamples(...): End");
        }
        if (DEBUG_LEV > 10) {
            System.err.println("--: bitsUsed : " + bits + "  : Bytes : " + bytesNeeded);
        }
        return encodedSamples;
    }
}

