/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.optionalcontent;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;

public class PDOptionalContentProperties
implements COSObjectable {
    private final COSDictionary dict;

    public PDOptionalContentProperties() {
        this.dict = new COSDictionary();
        this.dict.setItem(COSName.OCGS, (COSBase)new COSArray());
        this.dict.setItem(COSName.D, (COSBase)new COSDictionary());
    }

    public PDOptionalContentProperties(COSDictionary props) {
        this.dict = props;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dict;
    }

    private COSArray getOCGs() {
        COSArray ocgs = (COSArray)this.dict.getItem(COSName.OCGS);
        if (ocgs == null) {
            ocgs = new COSArray();
            this.dict.setItem(COSName.OCGS, (COSBase)ocgs);
        }
        return ocgs;
    }

    private COSDictionary getD() {
        COSDictionary d = (COSDictionary)this.dict.getDictionaryObject(COSName.D);
        if (d == null) {
            d = new COSDictionary();
            this.dict.setItem(COSName.D, (COSBase)d);
        }
        return d;
    }

    public PDOptionalContentGroup getGroup(String name) {
        COSArray ocgs = this.getOCGs();
        for (COSBase o : ocgs) {
            COSDictionary ocg = this.toDictionary(o);
            String groupName = ocg.getString(COSName.NAME);
            if (!groupName.equals(name)) continue;
            return new PDOptionalContentGroup(ocg);
        }
        return null;
    }

    public void addGroup(PDOptionalContentGroup ocg) {
        COSArray ocgs = this.getOCGs();
        ocgs.add(ocg.getCOSObject());
        COSArray order = (COSArray)this.getD().getDictionaryObject(COSName.ORDER);
        if (order == null) {
            order = new COSArray();
            this.getD().setItem(COSName.ORDER, (COSBase)order);
        }
        order.add(ocg);
    }

    public Collection<PDOptionalContentGroup> getOptionalContentGroups() {
        ArrayList<PDOptionalContentGroup> coll = new ArrayList<PDOptionalContentGroup>();
        COSArray ocgs = this.getOCGs();
        for (COSBase base : ocgs) {
            coll.add(new PDOptionalContentGroup(this.toDictionary(base)));
        }
        return coll;
    }

    public BaseState getBaseState() {
        COSDictionary d = this.getD();
        COSName name = (COSName)d.getItem(COSName.BASE_STATE);
        return BaseState.valueOf(name);
    }

    public void setBaseState(BaseState state) {
        COSDictionary d = this.getD();
        d.setItem(COSName.BASE_STATE, (COSBase)state.getName());
    }

    public String[] getGroupNames() {
        COSArray ocgs = (COSArray)this.dict.getDictionaryObject(COSName.OCGS);
        int size = ocgs.size();
        String[] groups = new String[size];
        for (int i = 0; i < size; ++i) {
            COSBase obj = ocgs.get(i);
            COSDictionary ocg = this.toDictionary(obj);
            groups[i] = ocg.getString(COSName.NAME);
        }
        return groups;
    }

    public boolean hasGroup(String groupName) {
        String[] layers;
        for (String layer : layers = this.getGroupNames()) {
            if (!layer.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupEnabled(String groupName) {
        BaseState baseState;
        COSArray off;
        COSDictionary d = this.getD();
        COSArray on = (COSArray)d.getDictionaryObject(COSName.ON);
        if (on != null) {
            for (COSBase o : on) {
                COSDictionary group = this.toDictionary(o);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                return true;
            }
        }
        if ((off = (COSArray)d.getDictionaryObject(COSName.OFF)) != null) {
            for (COSBase o : off) {
                COSDictionary group = this.toDictionary(o);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                return false;
            }
        }
        boolean enabled = !(baseState = this.getBaseState()).equals((Object)BaseState.OFF);
        return enabled;
    }

    private COSDictionary toDictionary(COSBase o) {
        if (o instanceof COSObject) {
            return (COSDictionary)((COSObject)o).getObject();
        }
        return (COSDictionary)o;
    }

    public boolean setGroupEnabled(String groupName, boolean enable) {
        COSArray off;
        COSDictionary d = this.getD();
        COSArray on = (COSArray)d.getDictionaryObject(COSName.ON);
        if (on == null) {
            on = new COSArray();
            d.setItem(COSName.ON, (COSBase)on);
        }
        if ((off = (COSArray)d.getDictionaryObject(COSName.OFF)) == null) {
            off = new COSArray();
            d.setItem(COSName.OFF, (COSBase)off);
        }
        boolean found = false;
        if (enable) {
            for (COSBase o : off) {
                COSDictionary group = this.toDictionary(o);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                off.remove(o);
                on.add(o);
                found = true;
                break;
            }
        } else {
            for (COSBase o : on) {
                COSDictionary group = this.toDictionary(o);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                on.remove(o);
                off.add(o);
                found = true;
                break;
            }
        }
        if (!found) {
            PDOptionalContentGroup ocg = this.getGroup(groupName);
            if (enable) {
                on.add(ocg.getCOSObject());
            } else {
                off.add(ocg.getCOSObject());
            }
        }
        return found;
    }

    public static enum BaseState {
        ON(COSName.ON),
        OFF(COSName.OFF),
        UNCHANGED(COSName.UNCHANGED);

        private final COSName name;

        private BaseState(COSName value) {
            this.name = value;
        }

        public COSName getName() {
            return this.name;
        }

        public static BaseState valueOf(COSName state) {
            if (state == null) {
                return ON;
            }
            return BaseState.valueOf(state.getName().toUpperCase());
        }
    }
}

